/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine.uniform;

import dev.engine_room.flywheel.lib.util.ExtraMemoryOps;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;

class UniformWriter {
    UniformWriter() {
    }

    static long writeInt(long ptr, int value) {
        MemoryUtil.memPutInt((long)ptr, (int)value);
        return ptr + 4L;
    }

    static long writeFloat(long ptr, float value) {
        MemoryUtil.memPutFloat((long)ptr, (float)value);
        return ptr + 4L;
    }

    static long writeVec2(long ptr, float x, float y) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        return ptr + 8L;
    }

    static long writeVec3(long ptr, float x, float y, float z) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)z);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)0.0f);
        return ptr + 16L;
    }

    static long writeVec3(long ptr, Vector3fc vec) {
        return UniformWriter.writeVec3(ptr, vec.x(), vec.y(), vec.z());
    }

    static long writeVec4(long ptr, float x, float y, float z, float w) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)z);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)w);
        return ptr + 16L;
    }

    static long writeIVec2(long ptr, int x, int y) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        return ptr + 8L;
    }

    static long writeIVec3(long ptr, int x, int y, int z) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)0);
        return ptr + 16L;
    }

    static long writeIVec4(long ptr, int x, int y, int z, int w) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)w);
        return ptr + 16L;
    }

    static long writeMat4(long ptr, Matrix4f mat) {
        ExtraMemoryOps.putMatrix4f(ptr, (Matrix4fc)mat);
        return ptr + 64L;
    }

    static long writeInFluidAndBlock(long ptr, class_1937 level, class_2338 blockPos, class_243 pos) {
        class_3610 fluidState = level.method_8316(blockPos);
        class_2680 blockState = level.method_8320(blockPos);
        float height = fluidState.method_15763((class_1922)level, blockPos);
        if (fluidState.method_15769()) {
            MemoryUtil.memPutInt((long)ptr, (int)0);
        } else if (pos.field_1351 < (double)((float)blockPos.method_10264() + height)) {
            if (fluidState.method_15767(class_3486.field_15517)) {
                MemoryUtil.memPutInt((long)ptr, (int)1);
            } else if (fluidState.method_15767(class_3486.field_15518)) {
                MemoryUtil.memPutInt((long)ptr, (int)2);
            } else {
                MemoryUtil.memPutInt((long)ptr, (int)-1);
            }
        }
        if (blockState.method_26215()) {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)0);
        } else if (blockState.method_27852(class_2246.field_27879)) {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)0);
        } else {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)-1);
        }
        return ptr + 8L;
    }
}

